import google.auth.transport.requests
import google_auth_oauthlib.flow

CLIENT_SECRETS_FILE = "client_secrets.json"
SCOPES = ["openid", "https://www.googleapis.com/auth/userinfo.profile", "https://www.googleapis.com/auth/userinfo.email"]

def authenticate_user():
    flow = google_auth_oauthlib.flow.InstalledAppFlow.from_client_secrets_file(
        CLIENT_SECRETS_FILE, SCOPES)
    
    credentials = flow.run_local_server(port=0)

    return credentials

def main():
    credentials = authenticate_user()

    #Test print to see the request
    #print("OAuth Credentials:", json.dumps(credentials.to_json(), indent=2))

    user_info_url = "https://www.googleapis.com/oauth2/v2/userinfo"
    headers = {"Authorization": f"Bearer {credentials.token}"}

    response = google.auth.transport.requests.Request().session.get(user_info_url, headers=headers)
    
    if response.status_code == 200:
        user_info = response.json()
        print("Logged-in User's Google Name:", user_info.get("name"))
        print("Logged-in User's Google Email:", user_info.get("email"))
    else:
        print("Failed to retrieve user information.")

if __name__ == "__main__":
    main()
