use rand::{distributions::Alphanumeric, Rng};
use std::fs::File;
use std::io::Write;

fn generate_random_string() -> String {
    rand::thread_rng()
        .sample_iter(&Alphanumeric)
        .take(6)
        .map(char::from)
        .collect()
}

fn write_to_file(filename: &str, count: usize) -> std::io::Result<()> {
    let mut file = File::create(filename)?;
    for _ in 0..count {
        writeln!(file, "{}", generate_random_string())?;
    }
    Ok(())
}

fn main() {
    if let Err(e) = write_to_file("random_strings.txt", 300_000) {
        eprintln!("Error writing to file: {}", e);
    } else {
        println!("Random strings generated and saved to random_strings.txt");
    }
}