public class Program
{
	public static void Main()
	{
		var script = new Scriptures();
		var verse = script.GetRandomVerseWithHiddenWords();
		Console.WriteLine(verse);
	}
}

public class Scriptures
{
	private string[] scripture = new string[]
	{
		 "Mosiah 2:17: And behold, I tell you these things that ye may learn wisdom; that ye may learn that when ye are in the service of your fellow beings ye are only in the service of your God.",
		 "1 Nephi 3:7: And it came to pass that I, Nephi said unto my father: I will go and do the things which the Lord hath commanded..."
	};
	string[] separators = new string[] { " " };

	private string GetRandomScripture()
	{
		var rand = new Random();
		int index = rand.Next(scripture.Length);
		return scripture[index];
	}

	public string GetRandomVerseWithHiddenWords()
	{
		var selectedScipture = GetRandomScripture();
		string[] outPutverse = new string[selectedScipture.Length];
		var splitVerse = selectedScipture.Split(separators, StringSplitOptions.None);

		foreach (var item in splitVerse.Select((value, index) => new { index, value }))
		{
			var rand = new Random();
			var tempValue = rand.Next(0, 20);
			if (tempValue % 4 == 0)
			{
				var hiddenWord = new string('_', item.value.Length);
				outPutverse[item.index] = hiddenWord + " ";
			}
			else
			{
				outPutverse[item.index] = item.value + " ";
			}
		}

		return string.Concat(outPutverse);
	}
}