let words = [];
let currentPair = {};
let score = 0;
let timer;
let isTimerRunning = false;
let initialRemainingClicks = 2; // Store the initial remaining clicks
let selectedDifficulty = "easy";
let timeLimit = 60;

/*---------------------------------------------- Submit Answer sortWord(); ----------------------------------------------------------*/

function sortWord() {
  const userInput = document
    .getElementById("word-input")
    .value.trim()
    .toLowerCase();

  const isCorrect = userInput === currentPair.word;

  if (isCorrect) {
    score += 10;
  } else {
    score -= 10;
  }

  document.getElementById("score-value").textContent = score;

  if (currentPair.remainingClicks > 0) {
    setTimeout(function () {
      newWord("submit-answer");
    }, 1000);
  }
}

/*---------------------------------------------- Generate Words ----------- ----------------------------------------------------------*/

function generateWordAndScrambled() {
  let newPair;
  do {
    newPair = words[Math.floor(Math.random() * words.length)];
  } while (newPair.word === currentPair.word);

  return { word: newPair.word, scrambled: newPair.scrambled };
}

function setDefaultGameUI() {
  // set up the UI for a new game
  // add timer UI functionality here
  document.getElementById("time-left").textContent = getTimeLimit(selectedDifficulty);
  document.getElementById("score-value").textContent = score;
  document.getElementById("remaining-clicks-value").textContent =
    currentPair.remainingClicks;
  document.getElementById("another-word-button").disabled = false;
  displayWord(currentPair.scrambled);
}

/*---------------------------------------------- AnotherWord newWord(); ----------------------------------------------------------*/

function newWord(source) {
  if (currentPair.remainingClicks > 0) {
    const { word, scrambled } = generateWordAndScrambled();
    currentPair = { ...currentPair, word, scrambled };
    if (source === "another-word-button") {
      currentPair.remainingClicks--;
    }
    updateUI();
  }
}

function updateUI() {
  document.getElementById("remaining-clicks-value").textContent =
    currentPair.remainingClicks; // update remaining clicks that the user can see
  if (currentPair.remainingClicks === 0) {
    document.getElementById("another-word-button").disabled = true; // if out of clicks disable the button
  }
  document.getElementById("word-input").value = "";
  displayWord(currentPair.scrambled); // update displayed word
}

/*---------------------------------------------- More Generated Words ----------------------------------------------------------------*/

function generateWords(difficulty) {
  return correctedWords(difficulty).map(({ word }) => ({
    word,
    scrambled: shuffleWord(word),
  }));
}

/*---------------------------------------------- The List of Words  ------------------------------------------------------------------*/
function correctedWords(difficulty) {
  const wordLists = {
    easy: [
      { word: "cat" },
      { word: "dog" },
      { word: "bat" },
      { word: "sun" },
      { word: "sky" },
      { word: "cup" },
      { word: "pen" },
      { word: "hat" },
      { word: "run" },
      { word: "box" },
      { word: "red" },
      { word: "lip" },
      { word: "top" },
      { word: "hop" },
      { word: "fly" },
      { word: "cry" },
      { word: "joy" },
      { word: "zip" },
      { word: "mix" },
      { word: "fun" },
    ],
    medium: [
      { word: "apple" },
      { word: "happy" },
      { word: "table" },
      { word: "house" },
      { word: "mouse" },
      { word: "plant" },
      { word: "water" },
      { word: "night" },
      { word: "music" },
      { word: "dance" },
      { word: "grape" },
      { word: "smile" },
      { word: "bread" },
      { word: "dream" },
      { word: "cloud" },
      { word: "light" },
      { word: "tiger" },
      { word: "robot" },
      { word: "piano" },
      { word: "flame" },
      { word: "guitar" },
      { word: "planet" },
      { word: "forest" },
    ],
    hard: [
      { word: "algorithm" },
      { word: "programming" },
      { word: "developer" },
      { word: "javascript" },
    ],
  };
  const selectedWordList = wordLists[difficulty] || wordLists.easy;

  // Now, we shuffle and return the words based on the selected difficulty
  return selectedWordList.map(({ word }) => ({
    word,
    scrambled: shuffleWord(word),
  }));
}

/*---------------------------------------- Event Listeners DIFFICULTIES-----------------------------------------*/

function changeDifficulty() {
  selectedDifficulty = document.getElementById("difficulty-select").value;
  startNewRound(selectedDifficulty);
}

document.getElementById("start-button").addEventListener("click", function () {
  if (!isTimerRunning) {
    const selectedDifficulty =
      document.getElementById("difficulty-select").value;
    startGame(selectedDifficulty);
    isTimerRunning = true;
  }
});

document
  .getElementById("another-word-button")
  .addEventListener("click", function () {
    if (currentPair.remainingClicks > 0) {
      const { word, scrambled } = generateWordAndScrambled();
      currentPair = {
        word,
        scrambled,
        remainingClicks: currentPair.remainingClicks - 1,
      };
      updateUI();
    } else {
      startNewRound();
    }
  });

document
  .getElementById("submit-answer-button")
  .addEventListener("click", function () {
    sortWord();
  });

/* ------------------------------------------ Shuffle and Display words --------------------------------------------------------------*/

function shuffleWord(word) {
  return word
    .split("")
    .sort(() => Math.random() - 0.5)
    .join("");
}

function displayWord(word) {
  const wordContainer = document.getElementById("word-container");
  wordContainer.innerHTML = "";
  for (let letter of word) {
    const letterSpan = document.createElement("span");
    letterSpan.textContent = letter;
    wordContainer.appendChild(letterSpan);
  }
}

/*----------------------------------------- startGame() , timer , reset score , new round ---------------------------------------------*/

function startGame(difficulty) {
  words = generateWords(difficulty);
  const { word, scrambled } = generateWordAndScrambled();
  currentPair = { word, scrambled, remainingClicks: initialRemainingClicks };

  timeLimit = getTimeLimit(selectedDifficulty);

  // Reset the timer
  clearInterval(timer);
  countdownTimer(timeLimit);

  setDefaultGameUI();
}

function resetScore() {
  score = 0;
  document.getElementById("score-value").textContent = score;
}

function startNewRound(difficulty) {
  currentPair = {};
  words = generateWords(difficulty);
  const { word, scrambled } = generateWordAndScrambled();
  currentPair = {
    word,
    scrambled,
    remainingClicks: getRemainingClicks(difficulty),
  };
  setDefaultGameUI();
}

/*--------------------------------------- DIFFICULTY SETTINGS ------------------------------------------------------------------------*/

function getTimeLimit(difficulty) {
  switch (difficulty) {
    case "easy":
      return 60;
    case "medium":
      return 45;
    case "hard":
      return 30;
    default:
      return 60;
  }
}

function getRemainingClicks(difficulty) {
  switch (difficulty) {
    case "easy":
    case "medium":
      return 2;
    case "hard":
      return 3;
    default:
      return 2;
  }
}

/*--------------------------------------------------- TIMER -------------------------------------------------------------------------*/

function countdownTimer(timeLimit) {
  timeleft = 60;
  timeLeft = timeLimit;
  updateTimerDisplay();

  timer = setInterval(() => {
    timeLeft--;

    if (timeLeft < 0) {
      timeLeft = 0;
    }

    updateTimerDisplay(timeLeft);

    if (timeLeft === 0) {
      clearInterval(timer);
      isTimerRunning = false;
    }
  }, 1000);
}

function updateTimerDisplay(timeLeft) {
  const timeDisplay = document.getElementById("time-left");
  timeDisplay.textContent = timeLeft;
}
